/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Random;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.LOTRShields;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityUmbarian;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityCorsair
extends LOTREntityUmbarian {
    private EntityAIBase rangedAttackAI = this.createHaradrimRangedAttackAI();
    private EntityAIBase meleeAttackAI;
    private static ItemStack[] weaponsCorsair = new ItemStack[]{new ItemStack(LOTRMod.swordCorsair), new ItemStack(LOTRMod.swordCorsair), new ItemStack(LOTRMod.daggerCorsair), new ItemStack(LOTRMod.daggerCorsairPoisoned), new ItemStack(LOTRMod.spearCorsair), new ItemStack(LOTRMod.spearCorsair), new ItemStack(LOTRMod.battleaxeCorsair), new ItemStack(LOTRMod.battleaxeCorsair)};

    public LOTREntityCorsair(World world) {
        super(world);
        this.addTargetTasks(true);
        this.spawnRidingHorse = false;
        this.npcShield = LOTRShields.ALIGNMENT_CORSAIR;
    }

    @Override
    protected EntityAIBase createHaradrimAttackAI() {
        this.meleeAttackAI = new LOTREntityAIAttackOnCollide(this, 1.6, true);
        return this.meleeAttackAI;
    }

    protected EntityAIBase createHaradrimRangedAttackAI() {
        return new LOTREntityAIRangedAttack(this, 1.5, 30, 40, 16.0f);
    }

    @Override
    protected LOTRFoods getHaradrimFoods() {
        return LOTRFoods.CORSAIR;
    }

    @Override
    protected LOTRFoods getHaradrimDrinks() {
        return LOTRFoods.CORSAIR_DRINK;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(npcRangedAccuracy).func_111128_a(0.5);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(weaponsCorsair.length);
        this.npcItemsInv.setMeleeWeapon(weaponsCorsair[i].func_77946_l());
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.npcItemsInv.setSpearBackup(this.npcItemsInv.getMeleeWeapon());
            this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.spearCorsair));
        }
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.nearHaradBow));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        this.func_70062_b(1, new ItemStack(LOTRMod.bootsCorsair));
        this.func_70062_b(2, new ItemStack(LOTRMod.legsCorsair));
        this.func_70062_b(3, new ItemStack(LOTRMod.bodyCorsair));
        if (this.field_70146_Z.nextInt(2) == 0) {
            this.func_70062_b(4, null);
        } else {
            this.func_70062_b(4, new ItemStack(LOTRMod.helmetCorsair));
        }
        return data;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(2, this.meleeAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(2, this.rangedAttackAI);
            this.func_70062_b(0, this.npcItemsInv.getRangedWeapon());
        }
    }

    @Override
    public void func_70074_a(EntityLivingBase entity) {
        super.func_70074_a(entity);
        if (entity instanceof LOTREntityNPC && ((LOTREntityNPC)entity).canDropRares() && this.field_70146_Z.nextInt(2) == 0) {
            int coins = this.getRandomCoinDropAmount();
            if ((coins = (int)((float)coins * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)1.0f, (float)3.0f))) > 0) {
                entity.func_145779_a(LOTRMod.silverCoin, coins);
            }
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        this.dropNPCArrows(i);
    }

    @Override
    protected void dropHaradrimItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.dropChestContents(LOTRChestContents.CORSAIR, 1, 2 + i);
        }
    }

    @Override
    public float getAlignmentBonus() {
        return 2.0f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "nearHarad/umbar/corsair/hired";
            }
            return "nearHarad/umbar/corsair/friendly";
        }
        return "nearHarad/umbar/corsair/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.CORSAIR.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.CORSAIR;
    }
}

